﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using VideoLib.Stereo.GpGpu;

namespace RealTimeStereoTestViewer
{
    public partial class TechniqueConfigurationControl : UserControl
    {
        private DisparityEstimationNode disparityNode;

        public TechniqueConfigurationControl(DisparityEstimationNode disparityNode)
        {
            InitializeComponent();
            this.disparityNode = disparityNode;
        }

        public string Title
        {
            set { groupBox.Text = value; }
        }

        private List<TechniqueDescription> techniques = new List<TechniqueDescription>();
        public List<TechniqueDescription> Techniques
        {
            get { return techniques; }
            set
            {
                if (value == null) techniques = new List<TechniqueDescription>();
                else techniques = value;

                // update radio buttons
                techniquesFlowLayoutPanel.Controls.Clear();
                foreach(TechniqueDescription technique in techniques)
                {
                    TechniqueRadioButton techniqueRB = new TechniqueRadioButton(technique, disparityNode);
                    techniquesFlowLayoutPanel.Controls.Add(techniqueRB);
                }

                // select the first technique
                /*foreach (var control in techniquesFlowLayoutPanel.Controls)
                {
                    if (control is TechniqueRadioButton)
                    {
                        TechniqueRadioButton button = (TechniqueRadioButton)control;
                        button.Checked = true;
                        break;
                    }
                }*/
            }
        }

        private class TechniqueRadioButton : RadioButton, IDisposable
        {
            private TechniqueDescription technique = null;
            private DisparityEstimationNode disparityNode = null;
            private readonly EventHandler validChangedHandler;
            private readonly EventHandler activeChangedHandler;

            public TechniqueRadioButton(TechniqueDescription techniqueDescription, DisparityEstimationNode disparityEstimationNode)
            {
                technique = techniqueDescription;
                disparityNode = disparityEstimationNode;
                AutoSize = true;
                Text = technique.Name;

                Checked = techniqueDescription.IsActive;

                CheckedChanged += new EventHandler(TechniqueRadioButton_CheckedChanged);
                validChangedHandler = new EventHandler(TechniqueRadioButton_ValidChanged);
                activeChangedHandler = new EventHandler(TechniqueRadioButton_ActiveChanged);
                technique.ValidChanged += validChangedHandler;
                technique.ActiveChanged += activeChangedHandler;
            }

            public TechniqueDescription Technique { get { return technique; } }

            private void TechniqueRadioButton_CheckedChanged(object sender, EventArgs e)
            {
                if (Checked)
                {
                    disparityNode.SetTechnique(technique);
                }
            }

            private void TechniqueRadioButton_ValidChanged(object sender, EventArgs e)
            {
                if(Created)
                    this.BeginInvoke(new Action(delegate{ this.Enabled = technique.IsValid; }));
            }

            private void TechniqueRadioButton_ActiveChanged(object sender, EventArgs e)
            {
                this.BeginInvoke(new Action(delegate{ this.Checked = technique.IsActive; }));
            }

            public new void Dispose()
            {
                technique.ValidChanged -= validChangedHandler;
                technique.ActiveChanged -= activeChangedHandler;
                base.Dispose();
            }
        }

        internal void ShowParameters(IStereoNode target)
        {
            // suspend layout to speed up updating
            parametersFlowLayoutPanel.SuspendLayout();
            tableLayoutPanel.SuspendLayout();
            groupBox.SuspendLayout();
            SuspendLayout();

            parametersFlowLayoutPanel.Controls.Clear();
            var control = new DynamicParametersControl(target, target.FollowerNodes, false);
            control.AutoSize = true;
            control.AutoSizeMode = AutoSizeMode.GrowAndShrink;
            parametersFlowLayoutPanel.Controls.Add(control);

            // resume layout
            parametersFlowLayoutPanel.ResumeLayout(false);
            parametersFlowLayoutPanel.PerformLayout();
            tableLayoutPanel.ResumeLayout(false);
            tableLayoutPanel.PerformLayout();
            groupBox.ResumeLayout(false);
            groupBox.PerformLayout();
            ResumeLayout(false);
            PerformLayout();
        }

        internal IEnumerable<DynamicParametersControl> GetParameterControls()
        {
            return parametersFlowLayoutPanel.Controls.OfType<DynamicParametersControl>();
        }

        internal void HideParameters(IStereoNode target)
        {
            parametersFlowLayoutPanel.Controls.Clear();
        }
    }
}
