#pragma once

#include "WtaSolveStereoNode.h"
#include "StereoNodeFactory.h"

// A basic wta solver implementation
class WtaStereoNode : public WtaSolveStereoNode
{
public:
	WtaStereoNode(cudaStream_t* stream) : WtaSolveStereoNode(stream) { }
	virtual ~WtaStereoNode() { }

	virtual void FindSolution(CostSpaceGrid & costGrid, DepthMap & depthMap);
};

// Creates instances of WtaStereoNode
class WtaStereoNodeFactory : public StereoNodeFactory<WtaSolveStereoNode>
{
public:
	// This WTA solver only works for single-float cost spaces (not half-float ones)
	virtual void CheckValid(RgbImageType imageType, CostSpaceGridType gridType, DepthMapType mapType) 
	{ 
		isValid = (gridType == COST_SPACE_GRID_TYPE_ANY || gridType == COST_SPACE_GRID_TYPE_SINGLE); 
	}

	virtual WtaSolveStereoNode* Create(cudaStream_t* stream) const { return new WtaStereoNode(stream); }
	virtual const char* GetName() const { return "WTA Solution"; }
};