// $Id: UnmanagedAggregators.h 65 2010-03-18 17:06:22Z cr333 $
#pragma once

#include <builtin_types.h>

template <typename T> class GpuTiledImages3D;

// Runs a box aggregation kernel horizontally and vertically. radius should be between 0 and 16
// The result is stored in costPtrOut
void RunBoxAggKernel(const cudaPitchedPtr & costPtr, int disparityMax, int radius, const cudaPitchedPtr & costPtrOut);

// Runs a minimum aggregation kernel horizontally and vertically. radius should be between 0 and 16
// The result is stored in costPtr
void RunMinAggKernel(const cudaPitchedPtr & costPtr, int disparityMax, int radius, const cudaPitchedPtr & interPtr);

void RunAggregationNaiveDCB(
	const cudaPitchedPtr& gpuCost,
	const unsigned int numDisps,
	const unsigned int* gpuImg1,
	const unsigned int* gpuImg2,
	const unsigned int pitch,
	const unsigned int w, const unsigned int h,
	const unsigned int radius, const float sigmaS, const float sigmaC);

void CalculateGridTextureSize(
	const unsigned int w, const unsigned int h, const unsigned int numDisps,
	const float sigmaS, const float sigmaC,
	unsigned int& texWidth, unsigned int& texHeight);

void RunAggregationDCBGrid(
	const cudaPitchedPtr& gpuCost,
	const unsigned int numDisps,
	const unsigned int* gpuImg1,
	const unsigned int* gpuImg2,
	const int pitch,
	float2* gpuGrid,
	const unsigned int gridWidth,
	const unsigned int gridHeight,
	const unsigned int gridPitch,
	unsigned int w, unsigned int h,
	float sigmaS, float sigmaC);

// The correct number of grids must be provided in gpuGrids.
// The previous grid should be stored in gpuGrids[1],
// and the new grid will be in gpuGrids[0].
void RunAggregationTDCBGrid(
	const cudaPitchedPtr& gpuCost,
	const unsigned int numDisps,
	const unsigned int* gpuImg1,
	const unsigned int* gpuImg2,
	const int pitch,
	float2** gpuGrids,
	const unsigned int numGrids,
	const unsigned int gridWidth,
	const unsigned int gridHeight,
	const unsigned int gridPitch,
	unsigned int w, unsigned int h,
	float sigmaS, float sigmaC,
	const int weighting, const float wa, const float wb);

void RunAggregationDCBGrid2(
	const cudaPitchedPtr& gpuCost,
	const unsigned int numDisps,
	const unsigned int* gpuImg1,
	const unsigned int* gpuImg2,
	const int pitch,
	GpuTiledImages3D<float2>* gpuGrids,
	unsigned int w, unsigned int h,
	float sigmaS, float sigmaC1, float sigmaC2);

// calculates the size of the grid texture for DCB Grid, so that it can be reused between frames
void CalculateGridTextureSize(
	const unsigned int w, const unsigned int h, const unsigned int numDisps,
	const float sigmaS, const float sigmaC,
	unsigned int& texWidth, unsigned int& texHeight);

// calculates the size of the grid texture for DCB Grid, so that it can be reused between frames
void CalculateGridTextureSize(
	const unsigned int w, const unsigned int h, const unsigned int numDisps,
	const float sigmaS, const float sigmaC1, const float sigmaC2,
	unsigned int& texWidth, unsigned int& texHeight);

void RunAggregationYoonKweon(
	const cudaPitchedPtr& gpuCost,
	const unsigned int numDisps,
	const unsigned int* gpuImg1,
	const unsigned int* gpuImg2,
	const unsigned int pitch,
	const unsigned int w, const unsigned int h,
	const int radius, const float gammaP, const float gammaC);