#pragma once

#include "WtaSolveStereoNode.h"
#include "StereoNodeFactory.h"

// A basic wta solver implementation
class SubPixWtaStereoNode : public WtaSolveStereoNode
{
public:
	SubPixWtaStereoNode(cudaStream_t* stream) : WtaSolveStereoNode(stream) { }
	virtual ~SubPixWtaStereoNode() { }

	virtual void FindSolution(CostSpaceGrid & costGrid, DepthMap & depthMap);
};

// Creates instances of WtaStereoNode
class SubPixWtaStereoNodeFactory : public StereoNodeFactory<WtaSolveStereoNode>
{
public:
	// This WTA solver only works for single-float cost spaces (not half-float ones)
	virtual void CheckValid(RgbImageType imageType, CostSpaceGridType gridType, DepthMapType mapType) 
	{ 
		isValid = (gridType == COST_SPACE_GRID_TYPE_ANY || gridType == COST_SPACE_GRID_TYPE_SINGLE); 
	}

	virtual SubPixWtaStereoNode* Create(cudaStream_t* stream) const { return new SubPixWtaStereoNode(stream); }
	virtual const char* GetName() const { return "Sub-pixel WTA Solution"; }
};