#include "StereoNodeFactoryWrap.h"

#include "SadCostStereoNode.h"
#include "MadCostStereoNode.h"
#include "BoxAggStereoNode.h"
#include "ShiftAggStereoNode.h"
#include "HbpOptStereoNode.h"
#include "WtaStereoNode.h"
#include "SubPixWtaStereoNode.h"

#include "SadCostStereoNodeSettings.h"
#include "MadCostStereoNodeSettings.h"
#include "BoxAggStereoNodeSettings.h"
#include "ShiftAggStereoNodeSettings.h"
#include "HbpOptStereoNodeSettings.h"
#include "WtaStereoNodeSettings.h"
#include "SubPixWtaStereoNodeSettings.h"

using namespace Stereo::GpGpuLib;

// Ugly hack due to compiler bug:
void DoNothing()
{
	gcnew StereoNodeFactoryListNodeWrap<PreProcStereoNode>(NULL, nullptr);
	gcnew StereoNodeFactoryListNodeWrap<CostComputeStereoNode>(NULL, nullptr);
	gcnew StereoNodeFactoryListNodeWrap<CostAggregateStereoNode>(NULL, nullptr);
	gcnew StereoNodeFactoryListNodeWrap<GlobalOptStereoNode>(NULL, nullptr);
	gcnew StereoNodeFactoryListNodeWrap<WtaSolveStereoNode>(NULL, nullptr);
	gcnew StereoNodeFactoryListNodeWrap<GuidedGlobalOptStereoNode>(NULL, nullptr);
}

StereoNodeFactoryListNodeWrap<PreProcStereoNode>^ GetPreFactoriesManaged()
{
	return nullptr;
}
StereoNodeFactoryListNodeWrap<CostComputeStereoNode>^ GetCostFactoriesManaged()
{
	StereoNodeFactoryListNodeWrap<CostComputeStereoNode>^ root = 
		gcnew StereoNodeFactoryListNodeWrap<CostComputeStereoNode>(new SadCostStereoNodeFactory(), gcnew CreateParams(&SadCostStereoNodeSettings::CreateParams));
	root->Next = 
		gcnew StereoNodeFactoryListNodeWrap<CostComputeStereoNode>(new MadCostStereoNodeFactory(), gcnew CreateParams(&MadCostStereoNodeSettings::CreateParams));

	return root;
}
StereoNodeFactoryListNodeWrap<CostAggregateStereoNode>^ GetAggregateFactoriesManaged()
{
	StereoNodeFactoryListNodeWrap<CostAggregateStereoNode>^ root = 
		gcnew StereoNodeFactoryListNodeWrap<CostAggregateStereoNode>(new BoxAggStereoNodeFactory(), gcnew CreateParams(&BoxAggStereoNodeSettings::CreateParams));
	root->Next = 
		gcnew StereoNodeFactoryListNodeWrap<CostAggregateStereoNode>(new ShiftAggStereoNodeFactory(), gcnew CreateParams(&ShiftAggStereoNodeSettings::CreateParams));

	return root;
}
StereoNodeFactoryListNodeWrap<GlobalOptStereoNode>^ GetOptFactoriesManaged()
{
	StereoNodeFactoryListNodeWrap<GlobalOptStereoNode>^ root = 
		gcnew StereoNodeFactoryListNodeWrap<GlobalOptStereoNode>(new HbpOptStereoNodeFactory(), gcnew CreateParams(&HbpOptStereoNodeSettings::CreateParams));
	
	return root;
}
StereoNodeFactoryListNodeWrap<WtaSolveStereoNode>^ GetWtaFactoriesManaged()
{
	StereoNodeFactoryListNodeWrap<WtaSolveStereoNode>^ root = 
		gcnew StereoNodeFactoryListNodeWrap<WtaSolveStereoNode>(new WtaStereoNodeFactory(), gcnew CreateParams(&WtaStereoNodeSettings::CreateParams));
	root->Next = 
		gcnew StereoNodeFactoryListNodeWrap<WtaSolveStereoNode>(new SubPixWtaStereoNodeFactory(), gcnew CreateParams(&SubPixWtaStereoNodeSettings::CreateParams));

	return root;
}
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<GuidedGlobalOptStereoNode>^ GetGuidedOptFactoriesManaged()
{
	return nullptr;
}