#pragma once

#include "StereoDataTypes.h"

#include "PreProcStereoNode.h"
#include "CostComputeStereoNode.h"
#include "CostAggregateStereoNode.h"
#include "GlobalOptStereoNode.h"
#include "WtaSolveStereoNode.h"
#include "GuidedGlobalOptStereoNode.h"

// The base class for factories able to create StereoNodes
class StereoNodeFactoryBase
{
protected:
	bool isValid;

public:
	StereoNodeFactoryBase() : isValid(true) { }

	bool IsValid() const { return isValid; }
	virtual void CheckValid(RgbImageType imageType, CostSpaceGridType gridType, DepthMapType mapType) = 0;

	virtual const char* GetName() const = 0;
};

template<typename T>
class StereoNodeFactory : public StereoNodeFactoryBase
{
public:
	virtual T* Create(cudaStream_t* stream) const = 0;
};

// The base class linking the templated list nodes together so that they can be held in unified collections
struct StereoNodeFactoryListNodeBase
{
public:
	virtual ~StereoNodeFactoryListNodeBase() { }

	virtual StereoNodeFactoryBase* GetFactory() const = 0;
	virtual StereoNodeFactoryListNodeBase* GetNext() const = 0;
};

// A linked list node for passing about collections of factories
template<typename T>
struct StereoNodeFactoryListNode : public StereoNodeFactoryListNodeBase
{
public:
	StereoNodeFactoryListNode(StereoNodeFactory<T>* theFactory) : pFactory(theFactory), pNext(0) { }
	virtual ~StereoNodeFactoryListNode()
	{
		if(pFactory != 0)
			delete pFactory;
		pFactory = 0;
	}

	virtual StereoNodeFactoryBase* GetFactory() const { return pFactory; }
	virtual StereoNodeFactoryListNodeBase* GetNext() const { return pNext; }

	StereoNodeFactory<T>* pFactory;
	StereoNodeFactoryListNode<T>* pNext;
};