#pragma once

#include "ShiftAggStereoNode.h"
#include "UnmanagedParameterTarget.h"

namespace Stereo { namespace GpGpuLib {
	ref class ShiftAggStereoNodeSettings
	{
	public:
		static IParameterTarget^ CreateParams(void* client)
		{
			UnmanagedParameterTarget<ShiftAggStereoNode>^ rParams = gcnew UnmanagedParameterTarget<ShiftAggStereoNode>("Shiftable cost aggregation");
			ShiftAggStereoNode* rClient = (ShiftAggStereoNode*)client;
			
			rParams->AddNewParameter<int>(rClient, &ShiftAggStereoNode::SetBoxFilterHalfSize,
				2, gcnew ContinuousParameterRange<int>(0, 15), 
				gcnew String("Box filter Half-size"), nullptr);
			
			rParams->AddNewParameter<int>(rClient, &ShiftAggStereoNode::SetMinFilterHalfSize,
				2, gcnew ContinuousParameterRange<int>(0, 15), 
				gcnew String("Min filter Half-size"), nullptr);

			return rParams;
		}
	};
} }
