#pragma once

#include "SadCostStereoNode.h"
#include "UnmanagedParameterTarget.h"

namespace Stereo { namespace GpGpuLib {
	ref class SadCostStereoNodeSettings
	{
	public:
		static IParameterTarget^ CreateParams(void* client)
		{
			UnmanagedParameterTarget<SadCostStereoNode>^ rParams = gcnew UnmanagedParameterTarget<SadCostStereoNode>("SAD Cost computation");
			SadCostStereoNode* rClient = (SadCostStereoNode*)client;
			
			rParams->AddNewParameter<float>(rClient, &SadCostStereoNode::SetCostGradient,
				10.0f, gcnew ContinuousParameterRange<float>(0.1f, 30.0f), 
				gcnew String("Cost gradient"), nullptr);
			
			rParams->AddNewParameter<float>(rClient, &SadCostStereoNode::SetCostLimit,
				10.0f, gcnew ContinuousParameterRange<float>(0.1f, 30.0f), 
				gcnew String("Cost limit"), nullptr);

			return rParams;
		}
	};
} }