// $Id: ManagedPreProcessors.cpp 65 2010-03-18 17:06:22Z cr333 $
#include "UnmanagedPreProcessors.h"
#include "ManagedPreProcessors.h"

using namespace Stereo::GpGpuLib;

void ManagedPreProcessors::RunResidualKernel(InputImage^ image, InputImage^ blurImage, float mixFactor)
{
	GpuImage* gpuImage = image->Get();
	GpuImage* gpuBlurImage = blurImage->Get();

	// Run residual (difference of two images) kernel
	RunImageDiffKernel(gpuImage->Get(), gpuImage->GetPitch() / sizeof(unsigned int), 
		gpuBlurImage->Get(), gpuBlurImage->GetPitch() / sizeof(unsigned int), 
		gpuImage->GetWidth(), gpuImage->GetHeight(), mixFactor);
}

void ManagedPreProcessors::RunBlurKernel(InputImage^ imageIn, InputImage^ temp, InputImage^ imageOut, float sigma)
{
	GpuImage* gpuImageIn = imageIn->Get();
	GpuImage* gpuTempImage = temp->Get();
	GpuImage* gpuImageOut = imageOut->Get();

	// Ensure that the temporary image is of the correct size (mirror image of the original image size)
	gpuTempImage->Create(gpuImageIn->GetType(), gpuImageIn->GetHeight(), gpuImageIn->GetWidth());

	// Ensure that the output image is of the correct size
	gpuImageOut->SizeToMatch(*gpuImageIn);

	// Run blur kernel (both directions)
	RunImageXBlurKernel(gpuImageIn->Get(), gpuImageIn->GetPitch() / sizeof(unsigned int), 
		gpuTempImage->Get(), gpuTempImage->GetPitch() / sizeof(unsigned int),
		gpuImageIn->GetWidth(), gpuImageIn->GetHeight(), sigma);

	RunImageXBlurKernel(gpuTempImage->Get(), gpuTempImage->GetPitch() / sizeof(unsigned int), 
		gpuImageOut->Get(), gpuImageOut->GetPitch() / sizeof(unsigned int),
		gpuTempImage->GetWidth(), gpuTempImage->GetHeight(), sigma);
}


void ManagedPreProcessors::RunBilSubKernel(InputImage^ imageIn, InputImage^ tempImage, int radius, float sigmaS, float sigmaR)
{
	// ensure that the temporary image has the same size as the input image
	tempImage->SizeToMatch(imageIn);

	// run the kernel (it copies the result back into the input image)
	::RunBilSubKernel(
		imageIn->GetPointer(), imageIn->Pitch,
		tempImage->GetPointer(), tempImage->Pitch,
		imageIn->Width, imageIn->Height,
		radius, sigmaS, sigmaR);
}