#pragma once

#include "MadCostStereoNode.h"

namespace Stereo { namespace GpGpuLib {
	ref class MadCostStereoNodeSettings
	{
	public:
		static IParameterTarget^ CreateParams(void* client)
		{
			UnmanagedParameterTarget<MadCostStereoNode>^ rParams = gcnew UnmanagedParameterTarget<MadCostStereoNode>("MAD Cost computation");
			MadCostStereoNode* rClient = (MadCostStereoNode*)client;
			
			rParams->AddNewParameter<float>(rClient, &MadCostStereoNode::SetCostGradient,
				10.0f, gcnew ContinuousParameterRange<float>(0.1f, 30.0f), 
				gcnew String("Cost gradient"), nullptr);
			
			rParams->AddNewParameter<float>(rClient, &MadCostStereoNode::SetCostLimit,
				10.0f, gcnew ContinuousParameterRange<float>(0.1f, 30.0f), 
				gcnew String("Cost limit"), nullptr);

			return rParams;
		}
	};
} }