#pragma once

#include "GpuExecutionStream.h"

namespace Stereo { namespace GpGpuLib {

/// <summary>
/// A managed wrapper (indirectly) around a cuda stream
/// </summary>
public ref class ExecutionStream
{
private:
	GpuExecutionStream* stream;
	static initonly ExecutionStream^ nullStream = gcnew ExecutionStream(true);

public:
	ExecutionStream()
	{
		stream = new GpuExecutionStream(false); 
	}
	ExecutionStream(bool createNull)
	{
		stream = new GpuExecutionStream(createNull);
	}
	~ExecutionStream()
	{
		delete stream;
		stream = 0;
	}

	cudaStream_t GetStream() { return stream->Get(); }
	GpuExecutionStream* Get() { return stream; }

	/// <summary>
	/// Calls cudaStreamSynchronize on the stream
	/// </summary>
	/// <remarks>
	/// Does not currently do this - due to problems, it uses cudaThreadSyncrhonize() to sync across all streams
	/// </remarks>
	void Synchronize() { stream->Synchronize(); }

	/// <summary>
	/// Wraps the cuda default stream
	/// </summary>
	static property ExecutionStream^ NullStream
	{
		ExecutionStream^ get() { return nullStream; }
	}
};

} }