#pragma once

#include "DisparityEstimator.h"
#include "DisparityEstimationSettings.h"
#include "UnmanagedParameterTarget.h"

#include "HbpDisparityEstimator.h"

using namespace System;

namespace Stereo { namespace GpGpuLib {

	/// <summary>
	/// Provides access to the disparity estimation mapping functionality of the library
	/// <p/>Warning: Not thread safe - do not access with multiple threads, even if method invocations
	/// are synchronized. This is because the underlying CUDA has per-thread context, so resources
	/// allocated by one thread are not available to another.
	/// </summary>
	public ref class DisparityEstimationProvider
	{
	private:
		UnmanagedParameterTarget<HbpDisparityEstimator>^ params;
		DisparityEstimator* disparityEstimator;

		DisparityEstimationProvider(DisparityEstimator* dEstimator);

	public:
		~DisparityEstimationProvider();

		/// <summary>
		/// Fills an image with a greyscale depth-disparity map from the two input images
		/// </summary>
		/// <param name="inImageL">The left view (layed out without padding, width-first)</param>
        /// <param name="inImageR">The right view (layed out without padding, width-first)</param>
        /// <param name="width">The width of both of the input images</param>
        /// <param name="height">The height of both of the input images</param>
        /// <param name="ndisparities">The maximum disparity to evaluate</param>
		/// <param name="scaling">The scale factor to generate the map from disparities (commonly = 1/(ndisparities-1))</param>
		/// <param name="outImage">The estimated depth map (should be created beforehand, same dimensions as the two input images)</param>
		void ProcessFrame(array<unsigned int>^ inImageL, array<unsigned int>^ inImageR, 
							int width, int height, int ndisparities, float scaling, array<float>^ outImage);

		/// <summary>
		/// The set of mutable parameters relating to the current estimation map generation technique
		/// </summary>
		property IParameterTarget^ Parameters
		{
			IParameterTarget^ get() { return params; }
		}

		/// <summary>
		/// Factory method - used to create instances of <code>DisparityEstimationProvider</code>,
		/// as the constructor is private.
		/// </summary>
		static DisparityEstimationProvider^ Create(DisparityEstimationSettings^ settings);
	};
}}