#include "DisparityEstimationProvider.h"

#include "SimpleWtaDisparityEstimator.h"
#include "HbpDisparityEstimator.h"
#include "HbpSettings.h"

using namespace Stereo::GpGpuLib;

DisparityEstimationProvider::DisparityEstimationProvider(DisparityEstimator* dEstimator) 
	: disparityEstimator(dEstimator), params(gcnew UnmanagedParameterTarget<HbpDisparityEstimator>("HBP Disparity Estimator")) { }

DisparityEstimationProvider::~DisparityEstimationProvider()
{
	if(disparityEstimator != 0)
	{
		delete disparityEstimator;
		disparityEstimator = 0;
	}
}

void DisparityEstimationProvider::ProcessFrame(array<unsigned int>^ inImageL, array<unsigned int>^ inImageR, 
											   int width, int height, int ndisparities, float scaling, array<float>^ outImage)
{
	if(disparityEstimator != 0)
	{
		// Pin the pointers to allow unmanaged code to use them
		pin_ptr<unsigned int> pInImageL = &inImageL[0];
		pin_ptr<unsigned int> pInImageR = &inImageR[0];
		pin_ptr<float> pOutImage = &outImage[0];

		disparityEstimator->FindDisparityMap(pInImageL, pInImageR, width, height, ndisparities, scaling, pOutImage);
	}
}

DisparityEstimationProvider^ DisparityEstimationProvider::Create(DisparityEstimationSettings^ settings)
{
	DisparityEstimationProvider^ result = nullptr;
	
	switch(settings->technique)
	{
	case DisparityEstimationSettings::Technique::Wta:
		result = gcnew DisparityEstimationProvider(new SimpleWtaDisparityEstimator());
		break;
	case DisparityEstimationSettings::Technique::Hbp:
		result = gcnew DisparityEstimationProvider(new HbpDisparityEstimator());
		HbpDisparityEstimatorParams::AddHbpParameters(result->params, (HbpDisparityEstimator*)result->disparityEstimator);
		break;
	}

	return result;
}