#pragma once

#include "DisparityEstimation.h"

using namespace System;
using namespace System::Threading;
using namespace VideoLib;

namespace VideoLib { namespace Stereo { namespace GpGpu 
{
	public ref struct DisparityCallData
	{
	public:
		float* inImageL; 
		float* inImageR; 
		int width; 
		int height; 
		int ndisparities; 
		float scaling; 
		float* outImage;
	};

	/// <summary>
	/// This class is a simple wrapper around an unmanaged class which handles depth-map
	/// calculation using CUDA
	/// </summary>
	public ref class DisparityEstimationNode : Node
	{
	private:
		DisparityEstimator* disparityEstimator;
		static const int ConstantShift = 0;
		Thread^ cudaAccessThread;

		DisparityCallData^ processData;
		bool readyToProcess;
		bool cudaAccessExit;

		void CudaAccessMain();

	public:
		DisparityEstimationNode();
		virtual ~DisparityEstimationNode();

		virtual void Init() override;
		virtual void Process() override;
	};
}}}