// $Id: DcbSuperResKernel.cuh 886 2009-11-20 16:01:46Z cr333 $

#if defined(__CUDACC__) || defined(NVCC) // nvcc only

#include "cudatemplates/devicememory.hpp"

__global__ void CostFromDepthKernel(
    const cudaPitchedPtr dispmap,
    const cudaPitchedPtr costs,
    const int width,
    const int height,
    const int numDisps,
    const float scaleDisps,
    const float clipCost);


void RunCostFromDepth(
    const Cuda::DeviceMemory<float, 2>& gpuImgD,
    const Cuda::DeviceMemory<float, 3>& gpuCost,
    const float scaleDisps, const float clipCosts);

#endif


void RunDcbSuperResolution(
#ifdef UPSAMPLE_GROUND_TRUTH // FOR PAPER: upsample ground truth disparity map for comparison -----
float* gtDepth,
#endif // FOR PAPER: upsample ground truth disparity map for comparison ---------------------------
// - low res depth map: ptr, width, pitch, height
const float* inputDepth,
const unsigned int inputDepthStride,
const unsigned int inWidth,
const unsigned int inHeight,
const unsigned int inNumDisps,
// - high res input images: left ptr, right ptr, width, pitch, height
const unsigned int* leftImage,
const unsigned int* rightImage,
const unsigned int inputImageStride,
// - temporary cost space: ptr, pitch (have width, height of high res images)
cudaPitchedPtr tempCostSpace,
// - temporary grid texture: ptr, width, height, pitch
float2* tempGrid,
const unsigned int gridStride,
const unsigned int gridWidth,
const unsigned int gridHeight,
// - high res depth map: ptr, pitch (have width, height of high res images)
float* outputDepth,
const unsigned int outputDepthStride,
const unsigned int outWidth,
const unsigned int outHeight,
const unsigned int outNumDisps,
// parameters:
const float clipCosts,
const float sigmaS,
const float sigmaC,
const unsigned int numInterations
);