// $Id: CudaHelperCommon.cu 795 2009-10-02 10:53:26Z cr333 $
#include <stdio.h>
#include "CudaHelperCommon.cuh"

void RecordKernelLaunch(const char* kernelName, dim3 gridDimension, dim3 blockDimension)
{
	int nBlocks = gridDimension.x * gridDimension.y;
	int nThreadsPerBlock = blockDimension.x * blockDimension.y * blockDimension.z;

	printf("Starting kernel \"%s\" on grid: %dx%d with blocks %dx%dx%d (total %dx%d = %d threads)\n", kernelName, gridDimension.x, gridDimension.y, 
		blockDimension.x, blockDimension.y, blockDimension.z, nBlocks, nThreadsPerBlock, nBlocks * nThreadsPerBlock);
}

void LogEvent(const char* description)
{
	printf("%s\n", description);
}

// Throws an exception if an error occurred in a previous CUDA call.
bool CheckCudaError(const char* msg)
{
	// Ensure that all waiting threads have had time to finish
	cudaThreadSynchronize();

	// Get any errors reported by previous asynchronous kernel launches
    cudaError_t error = cudaGetLastError();
	if(error != cudaSuccess)
		ThrowCudaException(error, msg);

	return error == cudaSuccess;
}

// Throws an exception if an error occurred in the current CUDA call.
bool CudaCall(cudaError error, const char* functionName, const char* surroundingFunction, const char* file, int line)
{
	if(error != cudaSuccess)
		ThrowCudaException(error, functionName, surroundingFunction, file, line);

	return error == cudaSuccess;
}