#pragma once

#include "BoxAggStereoNode.h"
#include "UnmanagedParameterTarget.h"

namespace Stereo { namespace GpGpuLib {
	ref class BoxAggStereoNodeSettings
	{
	public:
		static IParameterTarget^ CreateParams(void* client)
		{
			UnmanagedParameterTarget<BoxAggStereoNode>^ rParams = gcnew UnmanagedParameterTarget<BoxAggStereoNode>("Box cost aggregation");
			BoxAggStereoNode* rClient = (BoxAggStereoNode*)client;
			
			rParams->AddNewParameter<int>(rClient, &BoxAggStereoNode::SetFilterHalfSize,
				2, gcnew ContinuousParameterRange<int>(0, 15), 
				gcnew String("Filter Half-size"), nullptr);

			return rParams;
		}
	};
} }