#pragma once

#include "CostComputeStereoNode.h"
#include "StereoNodeFactory.h"

// A basic sum-absolute-deviation cost space finder
class SadCostStereoNode : public CostComputeStereoNode
{
public:
	SadCostStereoNode(cudaStream_t* stream) : CostComputeStereoNode(stream) { }
	virtual ~SadCostStereoNode() { }

	virtual void ComputeCosts(RgbImage & leftIm, RgbImage & rightIm, CostSpaceGrid & costGrid);
	virtual CostSpaceGridType GetCostSpaceType() { return COST_SPACE_GRID_TYPE_SINGLE; }
	
#pragma region Parameters
private:
	// Parameters
	float costGradient;
	float costLimit;
public:
	// Parameter setters
	void SetCostGradient(void* pn) { costGradient = *(float*)pn; }
	void SetCostLimit(void* pn) { costLimit = *(float*)pn; }
#pragma endregion
};

// Creates instances of SadCostStereoNode
class SadCostStereoNodeFactory : public StereoNodeFactory<CostComputeStereoNode>
{
public:
	// For cost-compute factories, CheckValid should always give true
	virtual void CheckValid(RgbImageType imageType, CostSpaceGridType gridType, DepthMapType mapType) { isValid = true; }

	virtual CostComputeStereoNode* Create(cudaStream_t* stream) const { return new SadCostStereoNode(stream); }
	virtual const char* GetName() const { return "SAD Costs"; }
};