#pragma once

// The base class for disparity estimators
class DisparityEstimator
{
private:
	int initNdisparityValues;
	int initWidth;
	int initHeight;

protected:

	// Override in derived classes to actually process the frame pair
	virtual void GenerateDisparityMap(unsigned int* inImageL, unsigned int* inImageR, int width, int height, int ndisparities, float scaling, float* outImage)
	{
		for(int y = 0; y < height; y++)
			for(int x = 0; x < width; x++)
				outImage[width * y + x] = (float)((inImageL[width * y + x] >> 8) & 0xFF) / 255.0f;
	}

	// Override in derived classes to pre-reserve memory
	virtual void ReserveNewSpace(int width, int height, int ndisparities) { }

public:
	DisparityEstimator() : initNdisparityValues(0), initWidth(0), initHeight(0) { }
	virtual ~DisparityEstimator() { }

	void FindDisparityMap(unsigned int* inImageL, unsigned int* inImageR, int width, int height, int ndisparities, float scaling, float* outImage)
	{
		if(ndisparities != initNdisparityValues || width != initWidth || height != initHeight)
		{
			ReserveNewSpace(width, height, ndisparities);

			initNdisparityValues = ndisparities;
			initWidth = width;
			initHeight = height;
		}

		GenerateDisparityMap(inImageL, inImageR, width, height, ndisparities, scaling, outImage);
	}
};