#pragma once

#include "CostAggregateStereoNode.h"
#include "StereoNodeFactory.h"

// A basic wta solver implementation
class BoxAggStereoNode : public CostAggregateStereoNode
{
protected:
	CostSpaceGrid interGrid;

public:
	BoxAggStereoNode(cudaStream_t* stream) : CostAggregateStereoNode(stream) { }
	virtual ~BoxAggStereoNode() { }

	virtual void AggregateCosts(RgbImage & leftIm, RgbImage & rightIm, CostSpaceGrid & costGrid);
	
#pragma region Parameters
private:
	// Parameters
	int filterHalfSize;
public:
	// Parameter setters
	void SetFilterHalfSize(void* pn) { filterHalfSize = *(int*)pn; }
#pragma endregion
};

// Creates instances of WtaStereoNode
class BoxAggStereoNodeFactory : public StereoNodeFactory<CostAggregateStereoNode>
{
public:
	// This aggregator only works for single-float cost spaces (not half-float ones)
	virtual void CheckValid(RgbImageType imageType, CostSpaceGridType gridType, DepthMapType mapType) 
	{ 
		isValid = (gridType == COST_SPACE_GRID_TYPE_ANY || gridType == COST_SPACE_GRID_TYPE_SINGLE); 
	}

	virtual CostAggregateStereoNode* Create(cudaStream_t* stream) const { return new BoxAggStereoNode(stream); }
	virtual const char* GetName() const { return "Box aggregation"; }
};