%token <int> INT
%token <string> IDENT
%token PLUS MINUS TIMES DIV
%token LPAREN RPAREN
%token EOF
%start parse_it         /* the entry point */
%type <ast> parse_it
%%
        
parse_it: expr EOF                  { $1 }; 

expr:       INT                     { Number($1) }
          | LPAREN expr RPAREN      { $2 }
          | expr PLUS expr          { Binary(PlusOp, $1, $3) }
          | expr MINUS expr         { Binary(MinusOp, $1, $3) }
          | expr TIMES expr         { Binary(TimesOp, $1, $3) }
          | expr DIV expr           { Binary(DivOp, $1, $3) }
          ;

