{

} 

rule tokenize = parse
            [' ' '\t' '\n' ]     { tokenize lexbuf } (* skip white-space *)
          | ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9']* as lxm    
                                 { IDENT(lxm) }
          | ['0'-'9']+ as lxm    { INT(int_of_string lxm) }
          | '+'                  { PLUS }
          | '-'                  { MINUS }
          | '*'                  { TIMES }
          | '/'                  { DIV }
          | '('                  { LPAREN }
          | ')'                  { RPAREN }
          | eof                  { EOF }
