/*
 * This is an implementation of mutual exclsuion locks built over
 * counting semaphores.
 *
 * We use the semaphore's count value to indicate how many times the
 * lock may be acquired before the calling thread blocks.  In this
 * case -- for mutual exclusion locks -- the count is therefore
 * initialized to 1.
 *
 * Note that all of the concurrency control here is being provided
 * by the semaphore that is used: the methods here do not need
 * the "syncrhonized" modifier.
 */

public class Mutex {

	private CountingSemaphore s;

	public Mutex() {
		s = new CountingSemaphore(1);
	}

	public void acquire() throws InterruptedException {
		s.P();
	}

	public void release() {
		s.V();
	}
}
