public class SortExample {

	public static void main(String[] args) {
		try {
			sortints();
			sortnums();
			sortmixed();
		} catch (IncompatibleTypeException e) {
			System.out.println("Incompatible types: " + e.getMessage());
		}
	}

	static void sortints() throws IncompatibleTypeException {
		Sortable[] d =
			{
				new SortableInt(3),
				new SortableInt(5),
				new SortableInt(2),
				new SortableInt(4),
				new SortableInt(3),
				new SortableInt(5)};
		print(d);
		sort(d);
		print(d);
	}

	static void sortnums() throws IncompatibleTypeException {
		Sortable[] d =
			{
				new Integer(3),
				new Integer(5),
				new Integer(2),
				new Real(4.0f),
				new Real(3.0f),
				new Real(5.0f)};
		print(d);
		sort(d);
		print(d);
	}

	static void sortmixed() throws IncompatibleTypeException {
		Sortable[] d =
			{
				new SortableInt(3),
				new SortableInt(5),
				new Integer(2),
				new Integer(4),
				new Real(3.0f),
				new Real(5.0f)};
		print(d);
		sort(d);
		print(d);
	}

	static void print(Object[] data) {
		System.out.print("[");
		if (data.length > 0)
			System.out.print(data[0]);
		for (int i = 1; i < data.length; i++)
			System.out.print(", " + data[i]);
		System.out.println("]");
	}

	static void sort(Sortable[] data) throws IncompatibleTypeException {
		for (int i = 1; i < data.length; i++) {
			for (int j = i;
				(j > 0) && (data[j].compare(data[j - 1]) < 0);
				j--) {
				Sortable d = data[j];
				data[j] = data[j - 1];
				data[j - 1] = d;
			}
		}
	}
}
