public class BufferBasic implements Buffer {
	int value;
	boolean valid = false;
	Mutex m = new Mutex();
	CondVar cv = new CondVar();

	public void put(int i) throws InterruptedException {
		m.acquire();
		while (valid) {
			cv.CVWait(m);
		}
		value = i;
		valid = true;
		cv.CVNotifyAll();
		m.release();
	}

	public int get() throws InterruptedException {
		int result;

		m.acquire();
		while (!valid) {
			cv.CVWait(m);
		}
		valid = false;
		cv.CVNotifyAll();
		result = value;
		m.release();

		return result;
	}
}
