import javax.swing.*;
import java.awt.Dimension;

class DrawingFrame extends JFrame {

	private static String[][] menus =
		{
			{"File", "New", null, "Load", "Save", null, "Print", null, "Quit" },
			{"Colour", "Black", "Blue", "Red", "Green" }, 
			{"Fill", "On", "Off" }
	};

	private int width, height;

	DrawingFrame(String title, int width, int height) {
		super(title);

		this.width = width;
		this.height = height;

		DrawingCanvas canvas = new DrawingCanvas(this, 2 * width, 2 * height);
		JScrollPane pane = new JScrollPane(canvas);
		this.getContentPane().add(pane, "Center");

		JMenuBar menubar = new JMenuBar();
		this.setJMenuBar(menubar);

		for (int c = 0; c < menus.length; c++) {
			JMenu m = new JMenu(menus[c][0]);
			menubar.add(m);
			for (int r = 1; r < menus[c].length; r++) {
				if (menus[c][r] == null)
					m.addSeparator();
				else {
					JMenuItem i = new JMenuItem(menus[c][r]);
					m.add(i);
					i.setActionCommand(menus[c][r].toLowerCase());
					i.addActionListener(canvas);
				}
			}
		}
		this.pack();
		this.show();
	}

	public Dimension getPreferredSize() {
		return new Dimension(width, height);
	}
}
