class Real extends Number implements Sortable {
	float r;

	public Real(float f) {
		r = f;
	}

	public Number add(Number n) {
		return n instanceof Integer
			? new Real(r + ((Integer) n).i)
			: new Real(r + ((Real) n).r);
	}

	public String toString() {
		return r + ": Real";
	}

	public int compare(Sortable s) throws IncompatibleTypeException {
		if (s instanceof Integer)
			return r - ((Integer) s).i > 0 ? +1 : -1;
		else if (s instanceof Real)
			return r - ((Real) s).r > 0 ? +1 : -1;
		else
			throw new IncompatibleTypeException(this, s);
	}

}
