class ComplexExample {

  public static void main (String [] args) {
    Complex one = new Complex (1.0f),
              i = new Complex (0.0f, 1.0f),
            two = one.add (one),
              m = i.multiply (i);
    System.out.println ("one = " + one);     // one = (1.0, 0.0)
    System.out.println ("  i = " + i);       //   i = (0.0, 1.0)
    System.out.println ("two = " + two);     // two = (2.0, 0.0)
    System.out.println ("  m = " + m);       //   m = (-1.0, 0.0)
  };

};

class Complex {

  private float real, imaginary;

  Complex (float real) {
    this.real = real;
    this.imaginary = 0.0f;
  };

  Complex (float real, float imaginary) {
    this.real = real;
    this.imaginary = imaginary;
  };

  Complex add (Complex c) {
    return new Complex (this.real + c.real, this.imaginary + c.imaginary);
  };

  Complex multiply (Complex c) {
    return new Complex (this.real * c.real - this.imaginary * c.imaginary,
                        this.real * c.imaginary + this.imaginary * c.real);
  };

  public String toString () {
    return "(" + this.real + ", " + this.imaginary + ")";
  };

};
