;;; Local mods to configure ispell [TDA]

;;; I know this is supposed to be a constant - but...
;; (setq ispell-required-version '("3.1." 20))

;;; Override default dictionary-alist.
(setq ispell-dictionary-alist
      '((nil                            ; default (english.aff) 
         "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil)
        ("british"
         "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil)
        ("britishjoined"                ; british with joined words
         "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-C") nil)
        ("american"             ; 
         "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil)
        ("americanjoined"                ; american with joined words
         "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-C") nil)
        )
)
;;; Remove spurious menu items
(define-key ispell-menu-map [english] nil)
(define-key ispell-menu-map [deutsch] nil)
(define-key ispell-menu-map [deutsch8] nil)
(define-key ispell-menu-map [nederlands] nil)
(define-key ispell-menu-map [nederlands8] nil)
(define-key ispell-menu-map [svenska] nil)
(define-key ispell-menu-map [svenska8] nil)
(define-key ispell-menu-map [francais7] nil)
(define-key ispell-menu-map [francais] nil)
(define-key ispell-menu-map [francais-tex] nil)
(define-key ispell-menu-map [dansk] nil)
;;; Add new menu items

(define-key-after ispell-menu-map [britishjoined]
  '("Select BritishJoined" lambda nil (interactive)
    (ispell-change-dictionary "britishjoined")) [british])
(define-key-after ispell-menu-map [american]
  '("Select American" lambda nil (interactive)
    (ispell-change-dictionary "american")) [britishjoined])
(define-key-after ispell-menu-map [americanjoined]
  '("Select AmericanJoined" lambda nil (interactive)
    (ispell-change-dictionary "americanjoined")) [american])

(provide 'ispell-fixup)
