package uk.ac.cam.rkh23.DesignPatterns.Singleton;

public class Database {
	
	// This will contain the one true instance
	private static Database sDatabase = null;
	
	// Make the constructor private so no-one can create 
	// objects of type Database
	private Database() {}
	
	// A static method that can access the one true instance
	// and give it back to us
	public static Database getInstance() {
		if (sDatabase==null) sDatabase = new Database();
		return sDatabase;
	}
}
