(* 

   The Parsed AST 

*) 
type var = string 

type loc = Lexing.position 

type type_expr = 
   | TEint
   | TEbool 
   | TEunit 
   | TEarrow of type_expr * type_expr
   | TEproduct of type_expr * type_expr
   | TEunion of type_expr * type_expr
   | TEwildcard   (* only used internally for typechecking! *) 

type formals = (var * type_expr) list

type oper = ADD | MUL | SUB | LT | AND | OR | EQ | EQB | EQI

type unary_oper = NEG | NOT | READ 

type expr = 
       | Unit of loc  
       | What of loc 
       | Var of loc * var
       | Integer of loc * int
       | Boolean of loc * bool
       | UnaryOp of loc * unary_oper * expr
       | Op of loc * expr * oper * expr
       | If of loc * expr * expr * expr
       | Pair of loc * expr * expr
       | Fst of loc * expr 
       | Snd of loc * expr 
       | Inl of loc * expr 
       | Inr of loc * expr 
       | Case of loc * expr * lambda * lambda 
       | Lambda of loc * tlambda 
       | App of loc * expr * expr
       | Let of loc * binding_list * expr
       | LetFun of loc * var * tlambda * type_expr * expr
       | LetRecFun of loc * var * tlambda * type_expr * expr

and lambda = var * expr 

and tlambda = var * type_expr * expr 

and binding_list = (var * type_expr * expr) list  


