
val verbose : bool ref 

type address = int 

type label = string 

type location = label * (address option) 

type value = 
     | CON of Common.constant 
     | PAIR of value * value 
     | INL of value 
     | INR of value 
     | FUN of bool * closure    (* bool is a flag : true means recursive environment! *) 

and closure = location * env 

and instruction = 
  | PUSH of value 
  | UNARY of Past.unary_oper 
  | OPER of Past.oper 
  | TEST of location 
  | CASE of location 
  | GOTO of location
  | IPAIR 
  | FST
  | SND
  | IINL
  | IINR
  | APPLY
  | RETURN 
  | SWAP_POP 
  | LOOKUP of Past.var 
  | BIND of Past.var 
  | MK_CLOSURE of location * (Past.var list) 
  | MK_REC of location  * (Past.var list) 
  | SKIP 
  | HALT 

and l_instruction = NotLabelled of instruction  | Labelled of label * instruction 

and code = l_instruction list 

and binding = Past.var * value

and env = binding list

type env_or_value = 
  | EV of env           (* an environment on the run-time stack *) 
  | V of value          (* a value on the run-time stack *) 
  | RA of address    (* a return address on the run-time stack *) 

type env_value_stack = env_or_value list 

type state = address * env_value_stack 

val installed : (l_instruction array) ref

val step : state -> state 

val compile : Ast.expr -> code  

val driver : int -> state -> value 

val eval : Ast.expr * env -> value 

val interpret : Ast.expr -> value 

val string_of_value : value -> string 

