
/* Auxiliary code */

%{

let get_loc = Parsing.symbol_start_pos 

%}

/* Tokens and types */
%token<int> INT
%token<string> IDENT
%token EOF LPAREN RPAREN COMMA COLON ADD SUB MUL NOT EQUAL LT ANDOP OROP 
%token WHAT UNIT AND TRUE FALSE IF THEN ELSE LET REC IN END BOOL INTTYPE UNITTYPE 
%left ADD SUB MUL AND OR EQUAL LT NOT 
%start start
%type <Past.type_expr> texpr
%type <(Past.var * Past.type_expr) list> formals
%type <(Past.var * Past.type_expr * Past.expr) list> bindings
%type <Past.expr list> exprlist
%type <Past.expr> expr 
%type <Past.expr> start

%%

/* Grammar  */

start: 
| expr EOF { $1 }

expr:
| UNIT                               { Past.Unit (get_loc())}
| INT                                { Past.Integer (get_loc(), $1) }
| WHAT                               { Past.What (get_loc())} 
| IDENT                              { Past.Var (get_loc(), $1) }
| TRUE                               { Past.Boolean (get_loc(), true)}
| FALSE                              { Past.Boolean (get_loc(), false)}
| IDENT LPAREN exprlist RPAREN       { Past.App (get_loc(), $1, $3) }
| NOT expr                           { Past.UnaryOp(get_loc(), Past.NOT, $2) }
| SUB expr                           { Past.UnaryOp(get_loc(), Past.NEG, $2) }
| expr ADD expr                      { Past.Op(get_loc(), $1, Past.ADD, $3) }
| expr SUB expr                      { Past.Op(get_loc(), $1, Past.SUB, $3) }
| expr MUL expr                      { Past.Op(get_loc(), $1, Past.MUL, $3) }
| expr LT expr                       { Past.Op(get_loc(), $1, Past.LT, $3) }
| expr EQUAL expr                    { Past.Op(get_loc(), $1, Past.EQ, $3) }
| expr ANDOP expr                    { Past.Op(get_loc(), $1, Past.AND, $3) }
| expr OROP expr                     { Past.Op(get_loc(), $1, Past.OR, $3) }
| LPAREN expr RPAREN                 { $2 }
| IF expr THEN expr ELSE expr        { Past.If(get_loc(), $2, $4, $6) }
| LET bindings IN expr END           { Past.Let (get_loc(), $2, $4) }
| LET IDENT LPAREN formals RPAREN COLON texpr EQUAL expr IN expr END 
                                     { Past.LetFun (get_loc(), $2, $4, $7, $9, $11) }

bindings: 
| IDENT COLON texpr EQUAL expr       { [($1, $3, $5)] }
| IDENT COLON texpr EQUAL expr AND bindings        
                                     { ($1, $3, $5) :: $7 }

exprlist: 
| expr                               { [$1] }
| expr COMMA exprlist                { $1 :: $3 }

formals: 
| IDENT COLON texpr                  { [($1, $3)] }
| IDENT COLON texpr COMMA formals    { ($1, $3) :: $5 }

texpr: 
| BOOL                               { Past.TEbool }
| INTTYPE                            { Past.TEint }
| UNITTYPE                           { Past.TEunit }




