package uk.ac.cam.rkh23.DP2013.Singleton;

import uk.ac.cam.rkh23.DP2013.Proxy.FullCustomer;

public class DatabaseConn {
	
	// This will contain the one true instance
	private static DatabaseConn sDatabase = null;
	
	// Make the constructor private so no-one can create 
	// objects of type Database
	private DatabaseConn() {
		// Assume we do something costly here
	}
	
	// A static method that can access the one true instance
	// and give it back to us. This is a lazy implementation
	// that only creates the Database object on the first request
	public static DatabaseConn getInstance() {
		if (sDatabase==null) sDatabase = new DatabaseConn();
		return sDatabase;
	}
	
	public static FullCustomer getCustomer(String name) {
		// Get details
		int pin = 1234;
		return new FullCustomer(name,pin);
	}
}
