package uk.ac.cam.rkh23.DP2013.Observer;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class SensorManager {
	
	// Singleton (not required but sensible here)
	private SensorManager() {}
	private static SensorManager sInstance = new SensorManager();
	public static SensorManager getInstance() { return sInstance; }
	
	
	private Random r = new Random();
	private List<SensorEventListener> mListeners = 
			new LinkedList<SensorEventListener>();
	
	public void registerListener(SensorEventListener l) {
		mListeners.add(l);
	}
	
	public void newData() {
		float datum = r.nextFloat();
		for (SensorEventListener sel : mListeners) {
			sel.onSensorChanged(datum);
		}
	}
	
	
	public static void main(String[] args) {
		SensorManager sm = SensorManager.getInstance();
		sm.registerListener(new MySensorApp());
		sm.registerListener(new MySensorApp());
		while (true) {
			sm.newData();
			
			// Sleep a second
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		
	}

}
