//
// $Id: $
// (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis). 
//

#ifdef USE_VERILATED
#include "OR1200.h"
#else
#include "orsim_sc.h"
#endif

#include "busmux.h"
#include "cbgram.h"
#include "cbguart.h"
#include <iostream>

#define BENCH_CLK_HALFPERIOD 5
#define TIMESCALE_UNIT SC_NS

#define TRACE 0
#define MAX_NO_OF_CORES 256
int n_cores = 1;




int sc_main(int argc, char* argv[])
{
  const char *image_name = "image.out";

  while (argc > 2)
    {
      if (!strcmp(argv[1], "-cores"))
	{
	  n_cores = atoi(argv[2]);
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "-image"))
	{
	  image_name =argv[2];
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "--"))
	{
	  argv_backdoor = new argv_backdoor_setup(image_name, argc-2, argv+2); // Copy these ready for backdoor access
	  break;
	}
      else break;
    }

  assert (n_cores <= MAX_NO_OF_CORES);
  OR1200 *processor[MAX_NO_OF_CORES];

  sc_trace_file* Tf = 0;
 #if TRACE
  Tf = sc_create_vcd_trace_file("Top_trace");
  ((vcd_trace_file*)Tf)->sc_set_vcd_time_unit(-9);//NS resolution
 #endif

  cbgram memory0("memory0", 0x20000000, 0); // Tracing on/off in arg3
  cbgram memory1("memory1", 0x20000000, 1);
  cbguart uart0("uart0", 1, 1);

  busmux busmux0("busmux0", 0x20000000);
  busmux busmux1("busmux1", 0x40000000);

  busmux0.init_socket.bind(memory0.port0);
  busmux0.init_socket.bind(busmux1.targ_socket);


  busmux1.init_socket.bind(memory1.port0);
  busmux1.init_socket.bind(uart0.port0);



  memory0.loadme(image_name, true);

  for(int i=0;i<n_cores;i++)
    {
      char txt[20];
      sprintf(txt, "orpcore_%d", i);
      processor[i] = new OR1200(txt, i);
      processor[i]->initiator_socket.bind(busmux0.targ_socket);
    }

  printf("Simulation is beginning. cores=%i\n", n_cores);
  sc_start();
 
  if (Tf) sc_close_vcd_trace_file(Tf);

  return 0;

}






// eof
