/**********************************************************
 *  This work by Richard Leivers (rjl67@cam.ac.uk)        * 
 *  is licenced under the Creative Commons                *
 *  Attribution-Non-Commercial-Share Alike 2.0 UK:        *
 *  England & Wales License.                              *
 *                                                        *
 *  To view a copy of this licence, visit                 *
 *  http://creativecommons.org/licenses/by-nc-sa/2.0/uk/  *
 *  or send a letter to Creative Commons,                 *
 *  171 Second Street, Suite 300, San Francisco,          *
 *  California 94105, USA.                                *
 *                                                        *
 **********************************************************	
 *	Manchester Baby simulator in Java  	*
 * 	Richard Leivers - July 2009        	*
 * 										*
 *	MEMORY MODULE						*
 ****************************************/

import java.io.*;

public class Memory {
	
	// Array to act as the memory
	private int[] mem;
	
	public Memory (String source) throws IOException, Exception{
		
		// Access file given by argument
		// Incorrect file name will throw an exception to be printed
		DataInputStream dis = new DataInputStream(new FileInputStream(source));
	    BufferedReader br = new BufferedReader(new InputStreamReader(dis));
		
	    // Create array of 32 ints to represent 32x32 memory
		mem = new int[32];
		
		// Initialise to zero
		for (int i = 0; i < 32; i++) mem[i] = 0;
		
		// Loop through input file, ignoring first line (contains no of lines in file)
		boolean first = true;
		String line;
		while ((line = br.readLine()) != null)   {
			
			int lineNo; // to hold no of line in memory
			String lineContent; // to hold textual representation of data
			int lineData = 0; // to hold integer representation of data
			
			if (!first) {
				// number of line in memory is first 4 characters, in decimal
				lineNo = Integer.parseInt(line.substring(0,4),10);
				
				// binary representation of data is remainder of line (after no and colon)
				lineContent = line.substring(5);
				
				// data should be 32-bits long!
				if (lineContent.length() != 32) throw new Exception();
				
				// loop through data working out integer representation
				// LSB is unusually on the left, hence the need to do this manually
				// number is signed, MSB gives -2^31
				for (int i = 0; i < 31; i++) {
					if (lineContent.charAt(i) == '1') lineData += (1 << i);
				}
				if (lineContent.charAt(31) == '1') lineData -= (1 << 31);
				
				// add the data to memory at specified line and output result
				writeLine (lineNo, lineData);
				System.out.println ("Line " + lineNo + ": " + lineContent + " added to memory");
			}
			else {
				first = false;
			}
		}
		
		// Close file
		dis.close();
	}
	
	// adds data to index position in memory
	public void writeLine (int index, int data) {
		mem[index] = data;
		return;
	}

	// retrieves data from index location in memory
	public int getMemLine (int index) {
		return mem[index];
	}
}
