package uk.ac.cam.cl.rkh23.blobtracker;

import java.util.LinkedList;
import java.util.List;

public class ScanningRegionExtractor implements RegionExtractor {
	
	private final int[] mRegionMap;
	private final int mWidth;
	private final int mHeight;
	
	
	public ScanningRegionExtractor(int image_width, int image_height) {
		mRegionMap = new int[image_width*image_height];
		mWidth = image_width;
		mHeight = image_height;
	}
	

	@Override
	public List<Region> extractRegions(List<Pixel> pixels) {
		List< Region > regionlist = new LinkedList< Region >();
		
		// First we set everything to be unassigned. To do this
		// we choose a number for the cell that won't be used elsewhere
		int emptymark = mWidth*mHeight+1;
		for (int i=0; i<mWidth*mHeight; i++) mRegionMap[i]=emptymark;
		
		// We scan left to right, top to bottom through the fg pixels
		for (Pixel p : pixels) {
			int px = p.getX();
			int py = p.getY();
			int pi = p.getArrayIndex();
		
			boolean leftempty = true;
			boolean topempty = true;
			
			// Look left
			if (px>0 && mRegionMap[pi-1]!=emptymark) leftempty=false;
			
			// Look up
			if(py>0 && mRegionMap[pi-mWidth]!=emptymark) topempty=false;
			
			// This code runs if we might have to merge regions
			if (!topempty && !leftempty) {
				// Merge required!
				// Which two do we merge?
				int regionleft = pi-1;
				int headleft = pi-1;
				while (regionleft>=0) {
					regionleft = mRegionMap[regionleft];
					if(regionleft>=0) headleft=regionleft;
				}
				Region pixelsleft = regionlist.get(-regionleft-1);
				
				int regiontop = pi-mWidth;
				int headtop = pi-mWidth;
				while (regiontop>=0) {
					regiontop = mRegionMap[regiontop];
					if(regiontop>=0) headtop=regiontop;
				}
				Region pixelstop = regionlist.get(-regiontop-1);
				
				if (regiontop!=regionleft) {
					mRegionMap[headleft]=headtop;
					pixelstop.addAll(pixelsleft);
					pixelsleft.clear();
				}
				else {
					mRegionMap[pi]=pi-1;
					pixelsleft.add(p);
				}
			}
			
			
			// This code runs if we have to add the current pixel to the region on its left
			else if (!leftempty) {
				// Add to the region on the left
				int regionleft = pi-1;
				int headleft = pi-1;
				while (regionleft>=0) {
					regionleft = mRegionMap[regionleft];
					if(regionleft>=0) headleft=regionleft;
				}
				Region pixelsleft = regionlist.get(-regionleft-1);
				pixelsleft.add(p);
				mRegionMap[pi]=pi-1;
			}
			
			
			// This code runs if we have to add the current pixel to the region above it
			else if (!topempty) {
				// Add to the region on the left
				int regiontop = pi-mWidth;
				int headtop = pi-mWidth;
				while (regiontop>=0) {
					regiontop = mRegionMap[regiontop];
					if(regiontop>=0) headtop=regiontop;
				}
				List<Pixel> pixelstop = regionlist.get(-regiontop-1);
				pixelstop.add(p);
				mRegionMap[pi]=pi-mWidth;
			}
			
			// This code runs if it's a new region!
			else {
				Region r = new Region();
				r.add(p);
				regionlist.add(r);
				mRegionMap[pi]= -1*regionlist.size();
			}
			
		}
		
		return regionlist;
	}

}
