package uk.ac.cam.cl.rkh23.blobtracker;

public class AdaptiveBackgroundSubtractor implements PixelFilter {
	
	/**
	 * This array represents our notional 'background' image
	 */
	private float[] mR = null;
	private float[] mG = null;
	private float[] mB = null;
	private float[] mThresholds = null;
	private boolean mInitialised = false;
	
	private static float mAlpha = 0.0001f;
	
	public AdaptiveBackgroundSubtractor(int numpixels) {
		mR = new float[numpixels];
		mG = new float[numpixels];
		mB = new float[numpixels];
		mThresholds = new float[numpixels];
	}

	@Override
	public void ApplyFilter(int[] pixels) {
		
		if (!mInitialised) {
			for (int i=0; i<pixels.length; i++) {
				int r = ((pixels[i]>>16) & 0x000000FF);
				int g = ((pixels[i]>>8) & 0x000000FF);
				int b = ((pixels[i]) & 0x000000FF);
				mR[i]=r;
				mB[i]=b;
				mG[i]=g;
				mThresholds[i]=5.0f;
			}
			mInitialised=true;
			return;
		}
		
		
		// Analyse and learn
		for (int i=0; i<pixels.length; i++) {
			int r = ((pixels[i]>>16) & 0x000000FF);
			int g = ((pixels[i]>>8) & 0x000000FF);
			int b = ((pixels[i]) & 0x000000FF);
					
			
			float x = r;
			float diff = (r-mR[i])*(r-mR[i]) +	(b-mB[i])*(b-mB[i]) + (g-mG[i])*(g-mG[i]);
			if (diff>4*mThresholds[i]) {
				pixels[i]=0x00FF0000;
			}
			
			mR[i] = (1.0f-mAlpha)*mR[i] + mAlpha*(r+g+b)/3;
			mG[i] = (1.0f-mAlpha)*mG[i] + mAlpha*g;
			mB[i] = (1.0f-mAlpha)*mB[i] + mAlpha*b;
			mThresholds[i] = (1.0f-mAlpha)*mThresholds[i] + mAlpha*diff;
		}
		

	}

}
