package uk.ac.cam.cl.rkh23.blobtracker;

public class Pixel {
	
	private final int mX;
	private final int mY;
	private final int mIndex;
	
	public Pixel(int x, int y, int horiz_res) {
		mX=x;
		mY=y;
		mIndex=mY*horiz_res+x;
	}
	
	public Pixel(int index, int horiz_res) {
		mX=index%horiz_res;
		mY=(index-mX)/horiz_res;
		mIndex=index;
	}
	
	
	public int getX() { return mX; }
	public int getY() { return mY; }
	public int getArrayIndex() { return mIndex; }
	
}
