package uk.ac.cam.cl.rkh23.blobtracker;

import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.media.format.VideoFormat;

/**
 * A simple interface to retrieve individual frames from a video source.
 * In the lectures I use a webcam and the JMF to get images in. You may
 * wish to use a set of still images or a video, in which case you
 * may want to write your own FrameInterface implementation
 * @author Robert
 *
 */
public interface FrameInterface {
	
	/**
	 * Open a frame source that is somehow
	 * described by a String (e.g. filename or device ID)
	 * @param descriptor Descriptor of the frame source
	 */
	public void open(String descriptor);
	
	/**
	 * Get the next available image. If this is not
	 * instantly available, wait for it.
	 * @return Image of the next available frame
	 */
	public BufferedImage getNextFrame();

	/**
	 * Close the frame source
	 */
	public void close();

}
