package uk.ac.cam.cl.rkh23.bouncingball3;

import uk.ac.cam.cl.rkh23.bouncingball.Vector2D;

public class Floor extends MovingObject {
	private final double mOmega;
	private final double mAmplitude;
	private double mPhase = 0.0;
	
	
	public Floor(double centre_height, double omega, double amplitude) {
		super(0.0,centre_height, 0.0, amplitude*omega,0.0,0.0);
		mAmplitude = amplitude;
		mOmega = omega;
	}

	@Override
	public void updateState(double delta) {
		// phase loops every 1/w s
		// Each dt moves the phase by 2pi*w*dt 
		mPhase += mOmega*delta;
		if (mPhase>2.0*Math.PI) mPhase-=2.0*Math.PI;
		this.setAcceleration(new Vector2D(0.0, -1.0*mAmplitude*mOmega*mOmega*Math.sin(mPhase)));
		this.applyMotionEquations(delta);
	}
	
	/**
	 * Clone method.  All the state data are primitive types
	 * so a shallow copy is sufficient
	 */
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

}
