package framework;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import framework.Mesh.Face;
import framework.Mesh.Vertex;

public class OFFReader {
  
  private static class StringTokenizer {
    private String buffer;
    private int offset = 0;
    
    StringTokenizer(String val) {
      buffer = val;
      offset = 0;
    }
    
    boolean isspace(char c) {
      return (c == ' ') || (c == '\n') || (c == '\t');
    }
    
    String next(char token) {
      String ret = new String();
      
      while (isspace(buffer.charAt(offset)) || buffer.charAt(offset) == '#') {
        while (offset < buffer.length() && isspace(buffer.charAt(offset))) {
          offset++;
        }
        if (offset < buffer.length() && buffer.charAt(offset) == '#') {
          while (offset < buffer.length() && buffer.charAt(offset) != '\n') {
            offset++;
          }
        }
      }
      
      while (offset < buffer.length() && buffer.charAt(offset) != token) {
        ret = ret + buffer.charAt(offset++);
      }
      if (offset < buffer.length()) {
        offset++;
      }
      return ret.trim();
    }
  }

  public static Mesh read(String filename) {
    BufferedReader brv;
    String line;
    String data = new String();
    String chunk;
    StringTokenizer tokenizer, tokie;
    int nVerts, nFaces;
    Mesh mesh = new Mesh();

    try {
      brv = new BufferedReader(new FileReader(filename));
      while ((line=brv.readLine()) != null) {
        data = data + line + "\n";
      }
    } catch (IOException e) {
      System.out.println("IOException: " + e.getMessage());
      System.exit(-1);
      return null;
    }

    tokenizer = new StringTokenizer(data);
    chunk = tokenizer.next('\n');
    if (chunk.compareTo("OFF") != 0) {
      System.out.println("Ill-formatted OFF data read: " + chunk);
      System.exit(-1);
    }

    tokie = new StringTokenizer(tokenizer.next('\n'));
    nVerts = Integer.valueOf(tokie.next(' '));
    nFaces = Integer.valueOf(tokie.next(' '));
    
    Vertex verts[] = new Vertex[nVerts];

    for (int i = 0; i < nVerts; i++)
    {
      tokie = new StringTokenizer(tokenizer.next('\n'));
      double x = Double.valueOf(tokie.next(' '));
      double y = Double.valueOf(tokie.next(' '));
      double z = Double.valueOf(tokie.next(' '));

      verts[i] = new Vertex(new M3d(x, y, z));
    }
    for (int i = 0; i<nFaces; i++)
    {
      tokie = new StringTokenizer(tokenizer.next('\n'));
      int n = Integer.valueOf(tokie.next(' '));
      Vertex faceVerts[] = new Vertex[n];
      
      for (int j = 0; j < n; j++) {
        faceVerts[j] = verts[Integer.valueOf(tokie.next(' '))];
      }
      mesh.add(new Face(faceVerts));
    }

    mesh.computeAllNormals();
    return mesh;
  }
}
