package raytrace;

import static java.lang.Math.PI;

import java.awt.Frame;
import java.awt.event.KeyEvent;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

import raytrace.engine.Camera;
import raytrace.engine.Plane;
import raytrace.engine.RayTracer;
import raytrace.engine.Scene;
import raytrace.engine.Sphere;
import framework.M3d;
import framework.M4x4;
import framework.Renderer;

public class RayTracerDemo extends Renderer {
  
  Camera camera;
  Scene scene;
  GLTextureCanvas canvas;
  RayTracer raytracer;
  boolean autoResizeRequested = false;
  
  Sphere S;
  
  public static final int WIDTH = 512;
  public static final int HEIGHT = 512;
  
  public String getTitle() {
    return "Ray Tracer";
  }
  
  public RayTracerDemo() {
    canvas = new GLTextureCanvas(WIDTH, HEIGHT);
    cameraDistance = 1;
    showAxes = false;

    camera = new Camera(new M3d(4,4,10).times(4));
    scene = new Scene();
    scene.addLight(new M3d(20,20,0));

    Plane P = new Plane(new M3d(1,1,1));
    P.setLocalTransform(M4x4.translation(new M3d(0,-1.5,0)));
    P.getMaterial().setLightingCoefficients(1, 0.4, 0.4, 5);
    scene.add(P);

    S = new Sphere(new M3d(0.2, 0.6, 0.8));
    S.getMaterial().setLightingCoefficients(0.2, 0.4, 0.4, 5);
    S.getMaterial().setReflectivity(0);
    S.getMaterial().setTransparency(0.5);
    S.getMaterial().setRefractiveIndex(1.5);
    S.setLocalTransform(M4x4.scale(new M3d(1.5,1.5,1.5)));
    scene.add(S);

    raytracer = new RayTracer(scene, canvas, camera);
  }
  
  public RayTracerDemo withAutoResizeRequested() {
    autoResizeRequested = true;
    return this;
  }

  public void keyPressed(KeyEvent e) {
    switch (e.getKeyCode()) {
    default:
      super.keyPressed(e);
      break;
    case KeyEvent.VK_1:
      cameraDistance = 1;
      cameraTransform = new M4x4();
      break;
    case KeyEvent.VK_2:
      cameraDistance = 2;
      cameraTransform = M4x4.rotation(new M3d(0,1,0), -PI/8.0);
      cameraTransform.rotate(new M3d(1,0,-1), PI/8.0);
      cameraTransform.rotate(new M3d(0,0,1), 5*PI/64.0);
      break;
    case KeyEvent.VK_3:
      break;
    }
  }
  
  public void preDisplay(GLAutoDrawable glDrawable) {
    if (autoResizeRequested) {
      autoResizeRequested = false;
      Frame.getFrames()[0].setSize(512, 512);
    }
    super.preDisplay(glDrawable);
  }

  @Override
  public void display(GLAutoDrawable glDrawable) {
    final GL gl = glDrawable.getGL();

    preDisplay(glDrawable);
    raytracer.renderSceneProgressively();
    canvas.render(gl);
    postDisplay(glDrawable);
  }
}
