/*
 * Decompiled with CFR 0.152.
 */
class ParabolaPoint
extends MyPoint {
    double a;
    double b;
    double c;

    public ParabolaPoint(MyPoint mypoint) {
        super(mypoint);
    }

    public double realX() {
        return this.y;
    }

    public double realY(double d) {
        return d - this.x;
    }

    public CirclePoint calculateCenter(MyPoint mypoint, ArcNode arcnode, MyPoint mypoint1) {
        CirclePoint circlepoint = null;
        MyPoint mypoint2 = new MyPoint(arcnode.x - mypoint.x, arcnode.y - mypoint.y);
        MyPoint mypoint3 = new MyPoint(mypoint1.x - arcnode.x, mypoint1.y - arcnode.y);
        if (mypoint3.y * mypoint2.x > mypoint3.x * mypoint2.y) {
            double d5;
            double d4;
            double d = -mypoint2.x / mypoint2.y;
            double d1 = mypoint.y + mypoint2.y / 2.0 - d * (mypoint.x + mypoint2.x / 2.0);
            double d2 = -mypoint3.x / mypoint3.y;
            double d3 = arcnode.y + mypoint3.y / 2.0 - d2 * (arcnode.x + mypoint3.x / 2.0);
            if (mypoint2.y == 0.0) {
                d4 = mypoint.x + mypoint2.x / 2.0;
                d5 = d2 * d4 + d3;
            } else if (mypoint3.y == 0.0) {
                d4 = arcnode.x + mypoint3.x / 2.0;
                d5 = d * d4 + d1;
            } else {
                d4 = (d3 - d1) / (d - d2);
                d5 = d * d4 + d1;
            }
            circlepoint = new CirclePoint(d4, d5, arcnode);
        }
        return circlepoint;
    }

    public void init(double d) {
        double d1 = this.realX();
        double d2 = this.realY(d);
        this.a = 1.0 / (2.0 * d2);
        this.b = -d1 / d2;
        this.c = d1 * d1 / (2.0 * d2) + d2 / 2.0;
    }

    public double F(double d) {
        return (this.a * d + this.b) * d + this.c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] solveQuadratic(double d, double d1, double d2) throws Throwable {
        double[] ad = new double[2];
        double d3 = d1 * d1 - 4.0 * d * d2;
        if (d3 < 0.0) {
            throw new Throwable();
        }
        if (d == 0.0) {
            if (d1 == 0.0) throw new Throwable();
            ad[0] = -d2 / d1;
            return ad;
        } else {
            double d4 = Math.sqrt(d3);
            double d5 = -d1;
            double d6 = 2.0 * d;
            ad[0] = (d5 + d4) / d6;
            ad[1] = (d5 - d4) / d6;
        }
        return ad;
    }
}

