/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Rectangle;

class ArcNode
extends ParabolaPoint {
    ArcNode Next;
    ArcNode Prev;
    CirclePoint circlePoint;
    MyPoint startOfTrace;

    public ArcNode(MyPoint mypoint) {
        super(mypoint);
    }

    public void checkCircle(EventQueue eventqueue) {
        if (this.Prev != null && this.Next != null) {
            this.circlePoint = this.calculateCenter(this.Next, this, this.Prev);
            if (this.circlePoint != null) {
                eventqueue.insert(this.circlePoint);
            }
        }
    }

    public void removeCircle(EventQueue eventqueue) {
        if (this.circlePoint != null) {
            eventqueue.remove(this.circlePoint);
            this.circlePoint = null;
        }
    }

    public void completeTrace(MyCanvas mycanvas, MyPoint mypoint) {
        if (this.startOfTrace != null) {
            mycanvas.Voronoi.addElement(new MyLine(this.startOfTrace, mypoint));
            mycanvas.Delaunay.addElement(new MyLine(this, this.Next));
            this.startOfTrace = null;
        }
    }

    public void checkBounds(MyCanvas mycanvas, double d) {
        if (this.Next != null) {
            this.Next.init(d);
            if (d > this.Next.x && d > this.x && this.startOfTrace != null) {
                try {
                    double[] ad = this.solveQuadratic(this.a - this.Next.a, this.b - this.Next.b, this.c - this.Next.c);
                    double d1 = ad[0];
                    double d2 = d - this.F(d1);
                    Rectangle rectangle = mycanvas.getBounds();
                    if (d2 < this.startOfTrace.x && d2 < 0.0 || d1 < 0.0 || d2 >= (double)rectangle.width || d1 >= (double)rectangle.height) {
                        this.completeTrace(mycanvas, new MyPoint(d2, d1));
                    }
                }
                catch (Throwable _ex) {
                    System.out.println("*** exception");
                }
            }
            this.Next.checkBounds(mycanvas, d);
        }
    }

    public void insert(ParabolaPoint parabolapoint, double sline, EventQueue eventqueue) throws Throwable {
        boolean split = true;
        if (this.Next != null) {
            this.Next.init(sline);
            if (sline > this.Next.x && sline > this.x) {
                double[] xs = this.solveQuadratic(this.a - this.Next.a, this.b - this.Next.b, this.c - this.Next.c);
                if (xs[0] <= parabolapoint.realX() && xs[0] != xs[1]) {
                    split = false;
                }
            } else {
                split = false;
            }
        }
        if (split) {
            this.removeCircle(eventqueue);
            ArcNode arcnode = new ArcNode(parabolapoint);
            arcnode.Next = new ArcNode(this);
            arcnode.Prev = this;
            arcnode.Next.Next = this.Next;
            arcnode.Next.Prev = arcnode;
            if (this.Next != null) {
                this.Next.Prev = arcnode.Next;
            }
            this.Next = arcnode;
            this.checkCircle(eventqueue);
            this.Next.Next.checkCircle(eventqueue);
            this.Next.Next.startOfTrace = this.startOfTrace;
            this.startOfTrace = new MyPoint(sline - this.F(parabolapoint.y), parabolapoint.y);
            this.Next.startOfTrace = new MyPoint(sline - this.F(parabolapoint.y), parabolapoint.y);
        } else {
            this.Next.insert(parabolapoint, sline, eventqueue);
        }
    }

    public void paint(Graphics g, double d, double d1, boolean flag, boolean drawBeach) {
        double d2 = g.getClipBounds().height;
        ArcNode arcnode = this.Next;
        if (arcnode != null) {
            arcnode.init(d);
        }
        if (d == this.x) {
            double d3;
            double d4 = d3 = arcnode != null ? d - arcnode.F(this.y) : 0.0;
            if (drawBeach) {
                g.drawLine((int)d3, (int)this.y, (int)d, (int)this.y);
            }
            d2 = this.y;
        } else {
            if (arcnode != null) {
                if (d == arcnode.x) {
                    d2 = arcnode.y;
                } else {
                    try {
                        double[] ad = this.solveQuadratic(this.a - arcnode.a, this.b - arcnode.b, this.c - arcnode.c);
                        d2 = ad[0];
                    }
                    catch (Throwable _ex) {
                        d2 = d1;
                        System.out.println("*** error: No parabola intersection during ArcNode.paint() - SLine: " + d + ", " + this.toString() + " " + arcnode.toString());
                    }
                }
            }
            if (drawBeach) {
                boolean i = true;
                double d4 = 0.0;
                double d5 = d1;
                while (d5 < Math.min(Math.max(0.0, d2), (double)g.getClipBounds().height)) {
                    double d6 = d - this.F(d5);
                    if (d5 > d1 && (d4 >= 0.0 || d6 >= 0.0)) {
                        g.drawLine((int)d4, (int)(d5 - (double)i), (int)d6, (int)d5);
                    }
                    d4 = d6;
                    d5 += (double)i;
                }
            }
            if (flag && this.startOfTrace != null) {
                double d7 = d - this.F(d2);
                double d8 = d2;
                g.getClipBounds();
                g.getClipBounds();
                g.drawLine((int)this.startOfTrace.x, (int)this.startOfTrace.y, (int)d7, (int)d8);
            }
        }
        if (this.Next != null) {
            this.Next.paint(g, d, Math.max(0.0, d2), flag, drawBeach);
        }
    }
}

