/*
 * Decompiled with CFR 0.152.
 */
package shaders;

import framework.M3d;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import javax.media.opengl.GL;
import shaders.ShaderDemo;

public abstract class ShaderRenderer {
    protected int vShader;
    protected int fShader;
    protected int shaderProgram;
    private ShaderDemo torus;

    public ShaderRenderer(ShaderDemo torus) {
        this.torus = torus;
    }

    protected String[] readShader(String name) {
        LinkedList<String> lines = new LinkedList<String>();
        try {
            String line;
            BufferedReader brv = new BufferedReader(new FileReader("src/shaders/" + name));
            while ((line = brv.readLine()) != null) {
                lines.add(String.valueOf(line) + "\n");
            }
            String[] ret = new String[lines.size()];
            int i = 0;
            for (String s : lines) {
                ret[i++] = s;
            }
            return ret;
        }
        catch (IOException e) {
            System.out.println("IOException: " + e.getMessage());
            System.exit(-1);
            return null;
        }
    }

    protected int[] lineLengths(String[] lines) {
        int[] ret = new int[lines.length];
        int i = 0;
        while (i < lines.length) {
            ret[i] = lines[i].length();
            ++i;
        }
        return ret;
    }

    public void checkVersion(GL gl) {
        System.out.println("GL version: " + gl.glGetString(7938));
        System.out.println("GL shading language version: " + gl.glGetString(35724));
        System.out.println("GL shading language version (ARB): " + gl.glGetString(35724));
    }

    public void checkShader(GL gl, int shader, String filename) {
        String infolog;
        int[] check = new int[1];
        gl.glGetShaderiv(shader, 35716, check, 0);
        int logLength = check[0];
        byte[] compilecontent = new byte[logLength + 1];
        gl.glGetShaderInfoLog(shader, logLength, check, 0, compilecontent, 0);
        if (logLength > 1 && (infolog = new String(compilecontent)).trim().compareTo("No errors.") != 0) {
            this.checkVersion(gl);
            System.out.println("Info log for shader '" + filename + "' (ID " + shader + "):");
            System.out.println(infolog);
            System.exit(-1);
        }
    }

    public void checkProgram(GL gl, int program) {
        int[] check = new int[1];
        gl.glGetProgramiv(program, 35716, check, 0);
        int logLength = check[0];
        byte[] compilecontent = new byte[logLength + 1];
        gl.glGetProgramInfoLog(program, logLength, check, 0, compilecontent, 0);
        String infolog = new String(compilecontent);
        if (logLength > 1 && !infolog.trim().isEmpty()) {
            this.checkVersion(gl);
            System.out.println("Info Log of Program Object ID: " + program);
            System.out.println(infolog);
            gl.glGetProgramiv(program, 35715, check, 0);
            System.out.println("Status: " + check[0]);
            System.exit(-1);
        }
    }

    public abstract void init(GL var1);

    protected void init(GL gl, String vertexShader, String fragmentShader) {
        this.vShader = gl.glCreateShader(35633);
        String[] vsrc = this.readShader(vertexShader);
        gl.glShaderSource(this.vShader, vsrc.length, vsrc, this.lineLengths(vsrc), 0);
        gl.glCompileShader(this.vShader);
        this.checkShader(gl, this.vShader, vertexShader);
        this.fShader = gl.glCreateShader(35632);
        String[] fsrc = this.readShader(fragmentShader);
        gl.glShaderSource(this.fShader, fsrc.length, fsrc, this.lineLengths(fsrc), 0);
        gl.glCompileShader(this.fShader);
        this.checkShader(gl, this.fShader, fragmentShader);
        this.shaderProgram = gl.glCreateProgram();
        gl.glAttachShader(this.shaderProgram, this.vShader);
        gl.glAttachShader(this.shaderProgram, this.fShader);
        gl.glLinkProgram(this.shaderProgram);
        gl.glValidateProgram(this.shaderProgram);
        this.checkProgram(gl, this.shaderProgram);
        gl.glUseProgram(this.shaderProgram);
    }

    public void disable(GL gl) {
        gl.glDeleteProgram(this.shaderProgram);
    }

    protected void vertex(GL gl, int i, int j) {
        M3d normal = this.torus.getNormal(i, j);
        M3d vertex = this.torus.getVertex(i, j);
        gl.glNormal3dv(normal.get(), 0);
        gl.glVertex3dv(vertex.get(), 0);
    }

    public void display(GL gl) {
        gl.glBegin(7);
        int i = 0;
        while (i < 75) {
            int j = 0;
            while (j < 25) {
                this.vertex(gl, i, j);
                this.vertex(gl, i + 1, j);
                this.vertex(gl, i + 1, j + 1);
                this.vertex(gl, i, j + 1);
                ++j;
            }
            ++i;
        }
        gl.glEnd();
    }
}

