/*
 * Decompiled with CFR 0.152.
 */
package shaders;

import framework.M3d;
import framework.Renderer;
import java.awt.event.KeyEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import shaders.BasicRenderer;
import shaders.DiffuseRenderer;
import shaders.GoochRenderer;
import shaders.MandelbrotRenderer;
import shaders.ShaderRenderer;

public class ShaderDemo
extends Renderer {
    static final int di = 75;
    static final int dj = 25;
    static final float R = 5.0f;
    static final float r = 1.5f;
    boolean paused = false;
    double d = 0.0;
    M3d[][] torusPts;
    M3d[][] torusNormals;
    ShaderRenderer shaderRenderer = new BasicRenderer(this);
    ShaderRenderer nextShader = null;

    public ShaderDemo() {
        int j;
        this.torusPts = new M3d[75][25];
        this.torusNormals = new M3d[75][25];
        int i = 0;
        while (i < 75) {
            j = 0;
            while (j < 25) {
                this.torusPts[i][j] = this.torus(i, j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 75) {
            j = 0;
            while (j < 25) {
                this.torusNormals[i][j] = this.getVertex(i + 1, j).minus(this.getVertex(i, j)).cross(this.getVertex(i, j + 1).minus(this.getVertex(i, j))).plus(this.getVertex(i, j + 1).minus(this.getVertex(i, j)).cross(this.getVertex(i - 1, j).minus(this.getVertex(i, j)))).plus(this.getVertex(i - 1, j).minus(this.getVertex(i, j)).cross(this.getVertex(i, j - 1).minus(this.getVertex(i, j)))).plus(this.getVertex(i, j - 1).minus(this.getVertex(i, j)).cross(this.getVertex(i + 1, j).minus(this.getVertex(i, j)))).normalized();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String getTitle() {
        return "Shader Demo";
    }

    @Override
    public void init(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        super.init(glDrawable);
        this.showAxes = false;
        this.cameraDistance = 15.0f;
        this.shaderRenderer.init(gl);
    }

    private M3d torus(double u, double v) {
        u = Math.PI * 2 * u / 75.0;
        v = Math.PI * 2 * v / 25.0 + Math.PI;
        M3d pt = new M3d(5.0 + 1.5 * Math.cos(v), 0.0, 1.5 * Math.sin(v));
        return new M3d(pt.get(0) * Math.cos(u) - pt.get(1) * Math.sin(u), pt.get(0) * Math.sin(u) + pt.get(1) * Math.cos(u), pt.get(2));
    }

    public M3d getVertex(int i, int j) {
        return this.torusPts[(i + 75) % 75][(j + 25) % 25];
    }

    public M3d getNormal(int i, int j) {
        return this.torusNormals[(i + 75) % 75][(j + 25) % 25];
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                this.paused = !this.paused;
                break;
            }
            case 65: {
                this.nextShader = new BasicRenderer(this);
                break;
            }
            case 66: {
                this.nextShader = new DiffuseRenderer(this);
                break;
            }
            case 67: {
                this.nextShader = new GoochRenderer(this);
                break;
            }
            case 68: {
                this.nextShader = new MandelbrotRenderer(this);
                break;
            }
            default: {
                super.keyPressed(e);
            }
        }
    }

    public void display(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        if (this.nextShader != null) {
            this.shaderRenderer.disable(gl);
            this.shaderRenderer = this.nextShader;
            this.shaderRenderer.init(gl);
            this.nextShader = null;
        }
        this.preDisplay(glDrawable);
        this.shaderRenderer.display(gl);
        this.postDisplay(glDrawable);
    }
}

