/*
 * Decompiled with CFR 0.152.
 */
package shaders;

import javax.media.opengl.GL;
import shaders.ShaderDemo;
import shaders.ShaderRenderer;

public class MandelbrotRenderer
extends ShaderRenderer {
    public MandelbrotRenderer(ShaderDemo torus) {
        super(torus);
    }

    @Override
    public void init(GL gl) {
        super.init(gl, "mandelbrot-vs.glsl", "mandelbrot-fs.glsl");
        gl.glBindAttribLocation(this.shaderProgram, 1, "maxSteps");
    }

    @Override
    protected void vertex(GL gl, int i, int j) {
        double numUSteps = 8.0;
        double numVSteps = 3.0;
        double u = (double)i / 74.0;
        double v = (double)j / 24.0;
        gl.glVertexAttrib1d(1, Math.floor(u * numUSteps * 4.0));
        u = u * numUSteps - Math.floor(u * numUSteps);
        v = v * numVSteps - Math.floor(v * numVSteps);
        u = u * 8.0 - 4.0;
        v = v * 8.0 - 4.0;
        gl.glTexCoord2d(u, v);
        super.vertex(gl, i, j);
    }
}

