/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.M3d;
import framework.M4x4;

public class Camera {
    public M3d position;
    public M3d direction;
    public M3d up;
    public M3d right;
    public float distanceToViewingPlane;
    public float viewWidth;
    public float viewHeight;

    public Camera(M3d pos) {
        this.position = pos;
        this.direction = this.position.times(-1.0).normalized();
        this.right = this.direction.cross(new M3d(0.0, 1.0, 0.0)).normalized();
        this.up = this.right.cross(this.direction).normalized();
        this.distanceToViewingPlane = 1.0f;
        this.viewWidth = 0.25f;
        this.viewHeight = 0.25f;
    }

    public void pivot(double x, double y) {
        M4x4 T = M4x4.rotation(new M3d(0.0, 1.0, 0.0), x);
        this.position = T.times(this.position);
        this.direction = T.times(this.direction);
        this.right = T.times(this.right);
        T = M4x4.rotation(this.right, y);
        this.position = T.times(this.position);
        this.direction = T.times(this.direction);
        this.up = this.right.cross(this.direction).normalized();
    }
}

